%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
%Introduced: Palamedes version 1.0.0 (NP)
%Modified: Palamedes version 1.2.0, 1.5.0 (see History.m)

function PFLookUpTable = PAL_AMPM_CreateLUT(priorAlphaValues, priorBetaValues, priorGammaValues, priorLambdaValues, StimLevels, PF)
    
[a b g l x] = ndgrid(priorAlphaValues, priorBetaValues, priorGammaValues, priorLambdaValues, StimLevels);
params.alpha = a;
params.beta = 10.^b;
params.gamma = g;
params.lambda = l;
PFLookUpTable = PF(params, x);