%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
% Introduced: Palamedes version 1.0.0 (NP)
% Modified: Palamedes version 1.1.1, 1.2.0, 1.4.0, 1.5.0 (see History.m)

function PM = PAL_AMPM_setupPM(varargin)

NumOpts = length(varargin);

message = 'As of Palamedes 1.5.0, alpha values vary across rows and beta values vary ';
message = [message 'across columns of a 2-D (alpha x beta) PM.pdf (in earlier versions this was '];
message = [message 'vice versa). This will affect behavior of code written for previous versions '];
message = [message 'ONLY if a user-supplied prior was used and/or if code performed operations '];
message = [message 'on PM.pdf (e.g., if PM.pdf was plotted using for example ''surf''). Code written for '];
message = [message 'earlier versions of Palamedes can be made compatible simply '];
message = [message 'by transposing any user-supplied prior (i.e., prior = prior'';) before passing it to '];
message = [message 'PAL_AMPM_setupPM and transposing PM.pdf before plotting it '];
message = [message '(e.g., surf(PM.pdf'') instead of surf(PM.pdf)).'];
warning('PALAMEDES:AMPM_setupPM_priorTranspose',message);
warning('off','PALAMEDES:AMPM_setupPM_priorTranspose');

if mod(NumOpts,2) == 0

    PM.priorAlphaRange = -2:.05:2;
    PM.priorBetaRange = -1:.05:1;
    PM.priorGammaRange = 0.5;
    PM.priorLambdaRange = 0.02;
    PM.stimRange = -1:.1:1;
    [PM.priorAlphas PM.priorBetas PM.priorGammas PM.priorLambdas] = ndgrid(PM.priorAlphaRange,PM.priorBetaRange,PM.priorGammaRange,PM.priorLambdaRange);
    PM.PF = @PAL_Weibull;%@PAL_Gumbel;
    PM.LUT = PAL_AMPM_CreateLUT(PM.priorAlphaRange, PM.priorBetaRange, PM.priorGammaRange, PM.priorLambdaRange, PM.stimRange, PM.PF);
    PM.prior = ones(size(PM.priorAlphas));
    PM.prior = PM.prior./sum(sum(sum(sum(PM.prior))));
    PM.pdf = PM.prior;
    pSuccessGivenx = PAL_AMPM_pSuccessGivenx(PM.LUT, PM.pdf);
    [PM.posteriorTplus1givenSuccess PM.posteriorTplus1givenFailure] = PAL_AMPM_PosteriorTplus1(PM.pdf, PM.LUT); 
    ExpectedEntropy = PAL_Entropy(PM.posteriorTplus1givenSuccess,4).*pSuccessGivenx + PAL_Entropy(PM.posteriorTplus1givenFailure,4).*(1-pSuccessGivenx);
    [MinEntropy PM.I] = min(squeeze(ExpectedEntropy));
    PM.xCurrent = PM.stimRange(PM.I);
    PM.x = PM.xCurrent;
    PM.numTrials = 50;
    PM.response = [];
    PM.stop = 0;
else 
    PM = varargin{1};
end

PM.firstsession = length(PM.x) == 1;

if NumOpts > 1
    opts(1) = cellstr('priorAlphaRange');
    opts(2) = cellstr('priorBetaRange');
    opts(3) = cellstr('priorGammaRange');
    opts(4) = cellstr('priorLambdaRange');
    opts(5) = cellstr('stimRange');
    opts(6) = cellstr('prior');
    opts(7) = cellstr('PF');
    opts(8) = cellstr('numTrials');
    opts(9) = cellstr('gamma');             %for compatibility with older usage
    opts(10) = cellstr('lambda');           %for compatibility with older usage
    supplied = logical(false(size(opts)));
    for opt = 1:length(opts)
        for n = 1:2:NumOpts-mod(NumOpts,2)
            n = n+mod(NumOpts,2);
            valid = 0;
            if strncmpi(varargin{n}, opts(1),6)            
                PM.priorAlphaRange = varargin{n+1};                
                valid = 1;
                supplied(1) = true;
            end
            if strncmpi(varargin{n}, opts(2),6)            
                PM.priorBetaRange = varargin{n+1};
                valid = 1;
                supplied(2) = true;
            end
            if strncmpi(varargin{n}, opts(3),6) || strncmpi(varargin{n}, opts(9),6)
                PM.priorGammaRange = varargin{n+1};                
                valid = 1;
                supplied(3) = true;
            end
            if strncmpi(varargin{n}, opts(4),6) || strncmpi(varargin{n}, opts(10),6)
                PM.priorLambdaRange = varargin{n+1};
                valid = 1;
                supplied(4) = true;
            end
            if strncmpi(varargin{n}, opts(5),4)            
                PM.stimRange = varargin{n+1};
                valid = 1;
                supplied(5) = true;
            end
            if strcmpi(varargin{n}, opts(6))
                PM.prior = varargin{n+1};
                PM.prior = PM.prior./sum(sum(sum(sum(PM.prior))));
                PM.pdf = PM.prior;
                valid = 1;
                supplied(6) = true;
            end
            if strcmpi(varargin{n}, opts(7))
                PM.PF = varargin{n+1};
                valid = 1;
                supplied(7) = true;
            end            
            if strncmpi(varargin{n}, opts(8),4)
                PM.numTrials = varargin{n+1};
                valid = 1;
                supplied(8) = true;
            end
            if valid == 0
                message = [varargin{n} ' is not a valid option. Ignored.'];
                warning(message);
            end        
        end            
    end
    if supplied(1) || supplied(2) || supplied(3) || supplied(4)
        [PM.priorAlphas PM.priorBetas PM.priorGammas PM.priorLambdas] = ndgrid(PM.priorAlphaRange,PM.priorBetaRange,PM.priorGammaRange,PM.priorLambdaRange);
        if ~supplied(6)
            PM.prior = ones(size(PM.priorAlphas));
            PM.prior = PM.prior./sum(sum(sum(sum(PM.prior))));
            if PM.firstsession == 1    %First session. Otherwise keep going with existing PM.pdf
                PM.pdf = PM.prior;
            end
        end
    end
    
    if supplied(1) || supplied(2) || supplied(3) || supplied(4) || supplied(5) || supplied(7) 
        PM.LUT = PAL_AMPM_CreateLUT(PM.priorAlphaRange,PM.priorBetaRange,PM.priorGammaRange,PM. priorLambdaRange,PM.stimRange,PM.PF);
        pSuccessGivenx = PAL_AMPM_pSuccessGivenx(PM.LUT, PM.pdf);
        [PM.posteriorTplus1givenSuccess PM.posteriorTplus1givenFailure] = PAL_AMPM_PosteriorTplus1(PM.pdf, PM.LUT);
        ExpectedEntropy = PAL_Entropy(PM.posteriorTplus1givenSuccess,4).*pSuccessGivenx + PAL_Entropy(PM.posteriorTplus1givenFailure,4).*(1-pSuccessGivenx);
        [MinEntropy PM.I] = min(squeeze(ExpectedEntropy));
        PM.xCurrent = PM.stimRange(PM.I);
    end
    if PM.firstsession == 1
        PM.x(1) = PM.xCurrent;
    end
end

if PM.firstsession == 1
    PM.threshold = []; 
    PM.slope = [];
    PM.guess = [];
    PM.lapse = [];
    PM.seThreshold = [];
    PM.seSlope = [];
    PM.seGuess = [];
    PM.seLapse = [];
    
    PM.thresholdUniformPrior = [];
    PM.slopeUniformPrior = [];
    PM.guessUniformPrior = [];    
    PM.lapseUniformPrior = [];
    PM.seThresholdUniformPrior = [];
    PM.seSlopeUniformPrior = [];
    PM.seGuessUniformPrior = [];
    PM.seLapseUniformPrior = [];
end