%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
%Introduced: Palamedes version 1.0.0 (NP)
%Modified: Palamedes version 1.1.0, 1.5.0 (see History.m)

function Entropy = PAL_Entropy(pdf,varargin)

warningstates = warning('query','all');
warning off MATLAB:log:logOfZero

nds = ndims(pdf);

if ~isempty(varargin)
    nds = varargin{1};
end

Entropy = pdf.*log(pdf);
Entropy(isnan(Entropy)) = 0;          %effectively defines 0.*log(0) to equal 0.

for d = 1:nds
    Entropy = sum(Entropy,d);    
end
Entropy = -Entropy;
warning(warningstates)