%This copy distributed with jovcode.zip, which contains only those
%Palamedes files that are needed to replicate results presented in:
%
%Prins, N. (2012). The psychometric function: The lapse rate revisited.
%Journal Of Vision.
%
%
%In order to enjoy the full functionality of the Palamedes Toolbox 
%(including help comments for each user-end routine), visit 
%www.palamedestoolbox.org and download the full version of the toolbox.
%
%This code may not be reproduced and/or distributed in original or
%   modified form under a different name and/or authorship.
%
%Palamedes toolbox citation:
%
%Prins, N. & Kingdom, F.A.A. (2009) Palamedes: Matlab routines for
%analyzing psychophysical data. www.palamedestoolbox.org.
%
% Introduced: Palamedes version 1.2.0 (NP)
% Modified: Palamedes version 1.3.0, 1.3.1 (see History.m)

function [ paramsValues maxim LLspace] = PAL_PFML_BruteForceFit(StimLevels,NumPos, OutOfNum, searchGrid, PF, varargin)

    lapseFit = 'default';
    gammaEQlambda = logical(false);

    if ~isempty(varargin)
        NumOpts = length(varargin);
        for n = 1:2:NumOpts
            valid = 0;
            if strncmpi(varargin{n}, 'lapseFit',6)
                lapseFit = varargin{n+1};
                valid = 1;
            end
            if strncmpi(varargin{n}, 'gammaEQlambda',6)
                gammaEQlambda = logical(varargin{n+1});
                valid = 1;
            end
            if valid == 0
                message = [varargin{n} ' is not a valid option. Ignored.'];
                warning(message);
            end        
        end            
    end
    
    
    [StimLevels NumPos OutOfNum] = PAL_PFML_GroupTrialsbyX(StimLevels, NumPos, OutOfNum);    

    switch lower(lapseFit(1:3))
        case {'nap', 'def'}
            [paramsGrid.alpha paramsGrid.beta paramsGrid.gamma paramsGrid.lambda] = ndgrid(searchGrid.alpha,searchGrid.beta,searchGrid.gamma,searchGrid.lambda);
            if gammaEQlambda
                paramsGrid.gamma = paramsGrid.lambda;
            end
            LLspace = zeros(size(paramsGrid.alpha,1),size(paramsGrid.alpha,2),size(paramsGrid.alpha,3),size(paramsGrid.alpha,4));
            for level = 1:length(StimLevels)
               LLspace = LLspace + NumPos(level).*log(PF(paramsGrid,StimLevels(level)))+(OutOfNum(level)-NumPos(level)).*log(1-PF(paramsGrid,StimLevels(level)));
            end
        case 'jap' 
            [paramsGrid.alpha paramsGrid.beta paramsGrid.gamma paramsGrid.lambda] = ndgrid(searchGrid.alpha,searchGrid.beta,searchGrid.gamma,searchGrid.lambda);
            len = length(NumPos);            
            LLspace = zeros(size(paramsGrid.alpha,1),size(paramsGrid.alpha,2),size(paramsGrid.alpha,3),size(paramsGrid.alpha,4));
            if gammaEQlambda
                paramsGrid.gamma = paramsGrid.lambda;
                LLspace = log(paramsGrid.gamma.^NumPos(1))+log((1-paramsGrid.gamma).^(OutOfNum(1)-NumPos(1)));  %Unlike 0.*log(0), Matlab evaluates log(0.^0) as 0
            end
            LLspace = LLspace + log((1-paramsGrid.lambda).^NumPos(len))+log(paramsGrid.lambda.^(OutOfNum(len)-NumPos(len)));
            for level = 1+gammaEQlambda:len-1
                LLspace = LLspace + NumPos(level).*log(PF(paramsGrid,StimLevels(level)))+(OutOfNum(level)-NumPos(level)).*log(1-PF(paramsGrid,StimLevels(level)));
            end    
        case 'iap' 
            len = length(NumPos);
            if gammaEQlambda
                searchGrid.lambda = (OutOfNum(len)-NumPos(len)  +   NumPos(1))/(OutOfNum(len)+OutOfNum(1));
                searchGrid.gamma = searchGrid.lambda;
            else
                searchGrid.lambda = 1 - NumPos(len)/OutOfNum(len);
            end
            [paramsGrid.alpha paramsGrid.beta paramsGrid.gamma paramsGrid.lambda] = ndgrid(searchGrid.alpha,searchGrid.beta,searchGrid.gamma,searchGrid.lambda);                                    
            LLspace = zeros(size(paramsGrid.alpha,1),size(paramsGrid.alpha,2),size(paramsGrid.alpha,3),size(paramsGrid.alpha,4));
            LLspace = LLspace + log((1-searchGrid.lambda).^NumPos(len)) + log(searchGrid.lambda.^(OutOfNum(len)-NumPos(len)));
            if gammaEQlambda
                LLspace = LLspace + log((1-searchGrid.gamma).^(OutOfNum(1)-NumPos(1))) + log(searchGrid.gamma.^NumPos(1));
            end
            for level = 1+gammaEQlambda:len-1
               LLspace = LLspace + NumPos(level).*log(PF(paramsGrid,StimLevels(level)))+(OutOfNum(level)-NumPos(level)).*log(1-PF(paramsGrid,StimLevels(level)));
            end
    end
        
    [maxim I] = PAL_findMax(LLspace);
    
    while length(I) < 4
        I = [I 1];
    end
    
    paramsValues = [searchGrid.alpha(I(1)) searchGrid.beta(I(2)) searchGrid.gamma(I(3)) searchGrid.lambda(I(4))];

    if gammaEQlambda
        paramsValues(3) = paramsValues(4);
    end
end